/*
 * Decompiled with CFR 0.152.
 */
package jade.util.leap;

import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Serializable;
import java.util.Vector;

public class ArrayList
implements List,
Serializable {
    private Vector hiddenList;
    private static final long serialVersionUID = 3487495895819393L;
    private transient int modCount = 0;

    public ArrayList() {
        this.hiddenList = new Vector();
    }

    public ArrayList(int size) {
        this.hiddenList = new Vector(size);
    }

    public void clear() {
        ++this.modCount;
        this.hiddenList.removeAllElements();
    }

    public boolean contains(Object o) {
        return this.hiddenList.contains(o);
    }

    public Object get(int index) {
        return this.hiddenList.elementAt(index);
    }

    public int indexOf(Object o) {
        return this.hiddenList.indexOf(o);
    }

    public Object remove(int index) {
        ++this.modCount;
        Object oldElement = this.hiddenList.elementAt(index);
        this.hiddenList.removeElementAt(index);
        return oldElement;
    }

    public boolean add(Object o) {
        ++this.modCount;
        this.hiddenList.addElement(o);
        return true;
    }

    public void add(int index, Object o) {
        ++this.modCount;
        this.hiddenList.insertElementAt(o, index);
    }

    public boolean isEmpty() {
        return this.hiddenList.isEmpty();
    }

    public boolean remove(Object o) {
        ++this.modCount;
        return this.hiddenList.removeElement(o);
    }

    public Iterator iterator() {
        return new ListIterator();
    }

    public Object[] toArray() {
        Object[] returnedArray = new Object[this.hiddenList.size()];
        int i = 0;
        while (i < returnedArray.length) {
            returnedArray[i] = this.hiddenList.elementAt(i);
            ++i;
        }
        return returnedArray;
    }

    public int size() {
        return this.hiddenList.size();
    }

    public Object clone() {
        ArrayList cloned = new ArrayList();
        Iterator toClone = this.iterator();
        while (toClone.hasNext()) {
            cloned.add(toClone.next());
        }
        return cloned;
    }

    private class ListIterator
    implements Iterator {
        private int expectedModCount;
        private int index;

        private ListIterator() {
            this.expectedModCount = ArrayList.this.modCount;
            this.index = 0;
        }

        public boolean hasNext() {
            return this.index < ArrayList.this.hiddenList.size();
        }

        public Object next() throws RuntimeException {
            if (this.expectedModCount != ArrayList.this.modCount) {
                throw new RuntimeException("a concurrent modification has been occurred.");
            }
            return ArrayList.this.hiddenList.elementAt(this.index++);
        }

        public void remove() throws RuntimeException {
            if (this.expectedModCount != ArrayList.this.modCount) {
                throw new RuntimeException("a concurrent modification has been occurred.");
            }
            ArrayList.this.hiddenList.removeElementAt(--this.index);
            ArrayList.this.modCount++;
            ++this.expectedModCount;
        }
    }
}

